class Scene3 extends Phaser.Scene{

    constructor(){
        super("game");
    }

    create(){

        this.numAnswer=4;

        this.scoreSound = this.sound.add('scoreSnd');
        this.looseSound = this.sound.add('looseSnd');
        this.musicSound = this.sound.add('musicSnd');

        this.musicSound.play();


        this.game_background=this.add.image(0,0,"backgroundTrivia").setOrigin(0,0);

        this.answerBackGrounds=[this.answer_button_0=this.add.image(270, 1100,"idle"), this.answer_button_1=this.add.image(800,1100,"idle"), this.answer_button_2=this.add.image(270,1400,"idle"), this.answer_button_3=this.add.image(800,1400,"idle")];
// Ajustar el tamaño de cada imagen en el arreglo
const buttonWidth = 500; // Cambia el ancho a lo que necesites
const buttonHeight = 180; // Cambia la altura a lo que necesites

this.answerBackGrounds.forEach(button => {
    button.setDisplaySize(buttonWidth, buttonHeight);
});
        this.userEnalble=true;
        var centerX = this.cameras.main.centerX; // get the center x coordinate of the game window
        var centerY = this.cameras.main.centerY; // get the center y coordinate of the game window

        this.questionsData = this.cache.json.get('questions');
        this.questionData;
        this.actualQuestion=0;
        this.numbers = [];

        for (let i = 0; i < this.questionsData.questions.length; i++) {
            this.numbers.push(i);
        }
            this.randomNumbers = [];
            for (let i = 0; i < game.global.numQuestUser; i++) {
                const randomIndex = Phaser.Math.Between(0, this.numbers.length - 1);
                this.randomNumbers.push(this.numbers[randomIndex]);
                this.numbers.splice(randomIndex, 1);
            }

        /*this.indexText=this.add.text(80,510, "A", {
            font: "80px JohnsonDisplay-Medium",
            fill: "#000000",
            align: "center",
            wordWrap: { width: 530 }
           });
           this.indexText.setOrigin(0.5, 0.5);*/

        this.questionText=this.add.text(centerX, 530, "_", {
            font: "40px JohnsonDisplay-Medium",
            fill: "#ffffff",
            align: "center",
            wordWrap: { width: 720 }
           });
           this.questionText.setOrigin(0.5, 0.5);

           this.answerText_0=this.add.text(270, 1100, "_", {
            font: "28px JohnsonDisplay-Medium",
            fill: "black",
            align: "center",
            wordWrap: { width: 450 }
           });
           this.answerText_0.setOrigin(0.5, 0.5);

           this.answerText_1=this.add.text(800, 1100, "-", {
            font: "28px JohnsonDisplay-Medium",
            fill: "black",
            align: "center",
            wordWrap: { width: 450 }
           });
           this.answerText_1.setOrigin(0.5, 0.5);

           this.answerText_2=this.add.text(270, 1400, "-", {
            font: "28px JohnsonDisplay-Medium",
            fill: "black",
            align: "center",
            wordWrap: { width: 450 }
           });
           this.answerText_2.setOrigin(0.5, 0.5);

           
           this.answerText_3=this.add.text(800, 1400, "-", {
            font: "28px JohnsonDisplay-Medium",
            fill: "black",
            align: "center",
            wordWrap: { width: 450 }
           });
           this.answerText_3.setOrigin(0.5, 0.5);

           this.answerHideButtons=[this.answer_button_0=this.add.image(270, 1100,"idle"), this.answer_button_1=this.add.image(800,1100,"idle"), this.answer_button_2=this.add.image(270,1400,"idle"), this.answer_button_3=this.add.image(800,1400,"idle")];

           for(var i=0; i<this.numAnswer; i++){
            this.answerHideButtons[i].setAlpha(0.001);
            this.answerHideButtons[i].setInteractive();
           }
           
           for (let i = 0; i < this.answerHideButtons.length; i++) {
            this.answerHideButtons[i].setInteractive();
            this.answerHideButtons[i].on('pointerdown', () => {
                this.checkAnswer(i);
            });
        }
        this.questionImageBackground = this.add.image(centerX,centerY+800,"questionImageBackground").setAlpha(0);
        this.questionImage = this.add.image(centerX, centerY + 800, "questionImage_0").setAlpha(0).setInteractive();
        this.questionImage.on('pointerdown', () => this.nextQuestion());
        var scale = 0.55;
        this.questionImageBackground.setScale(scale);
        this.questionImage.setScale(scale);
        //this.questionImageBackground.setDisplaySize(1050, 1080); // Cambia el tamaño a 1920x1080
        //this.questionImage.setDisplaySize(1000, 1000); // Cambia el tamaño a 1920x1080

        this.time.delayedCall(100, this.displayQuestion, [this.actualQuestion], this);

    }

    nextQuestion() {
        this.tweens.add({
            targets: [this.questionImage,this.questionImageBackground],

            y: this.cameras.main.height + 200,
            alpha: 0,
            duration: 800,
            ease: 'Power2',
            onComplete: () => {
                this.displayQuestion(this.actualQuestion);
            }
        });
    }

    displayQuestion (index) {
        if(this.actualQuestion>=game.global.numQuestUser){
            this.scene.start('end');
            this.musicSound.stop();
        }

        else{
        this.userEnalble=true;
        this.answerBackGrounds[0].setTexture("idle");
        this.answerBackGrounds[1].setTexture("idle");
        this.answerBackGrounds[2].setTexture("idle");
        this.answerBackGrounds[3].setTexture("idle");
        
        this.tempIndex=(this.randomNumbers[index]);
        this.questionData = this.questionsData.questions[this.tempIndex];
        //this.indexText.text=index+1;
        this.questionText.text=this.questionData.question;
        this.answerText_0.text=this.questionData.answers[0];
        this.answerText_1.text=this.questionData.answers[1];
        this.answerText_2.text=this.questionData.answers[2];
        this.answerText_3.text=this.questionData.answers[3];

        this.questionImage.setTexture('questionImage_'+[this.questionData.image]).setY(this.cameras.main.height + 200).setAlpha(0);

        console.log(this.questionData.image+'--questionImage_'+[this.questionData.image]);
        
        this.actualQuestion++;
        }

      }

    showQuestionImage(){

        this.time.delayedCall(500, () => {
            this.tweens.add({
                targets: [this.questionImage,this.questionImageBackground],
                y: this.cameras.main.centerY,

                alpha: 1,
                duration: 500,
                ease: 'Power2',
                onComplete: () => {
                    this.questionText.text="";
                    this.answerText_0.text="";
                    this.answerText_1.text="";
                    this.answerText_2.text="";
                    this.answerText_3.text="";
                    this.answerBackGrounds[0].setTexture("idle");
                    this.answerBackGrounds[1].setTexture("idle");
                    this.answerBackGrounds[2].setTexture("idle");
                    this.answerBackGrounds[3].setTexture("idle");
                }
            });
        }, [], this);
       
    }
    
    checkAnswer (A_index){
        //show correct or wrong indicator
        if(this.userEnalble==true){
            this.userEnalble=false;
        if (A_index === this.questionData.correctAnswerIndex) {
            this.answerBackGrounds[A_index].setTexture("correct");        
            

                this.tweens.add({
                    targets: this.answerBackGrounds[A_index],
                     // pequeña sacudida hacia la derecha
                     scale: 0.94,
                    duration: 200,
                    yoyo: true, // regresa al punto original
                    repeat: 1,  // número de sacudidas
                    ease: 'Power1'

                });
  
            this.answerBackGrounds[A_index].setDisplaySize(500, 180); // Ajustar a tu tamaño deseado
            this.scoreSound.play();
            this.game.global.score+=20;
          } else {

            this.answerBackGrounds.forEach(answerButton => {
                this.tweens.add({
                    targets: answerButton,
                     // pequeña sacudida hacia la derecha
                    y: answerButton.y + 5,
                    duration: 50,
                    yoyo: true, // regresa al punto original
                    repeat: 3,  // número de sacudidas
                    ease: 'Power1'
                });
            });

            this.answerBackGrounds[A_index].setTexture("wrong");
            this.answerBackGrounds[this.questionData.correctAnswerIndex].setTexture("correct");
            this.looseSound.play();
            console.log('Incorrect!');
          }
          this.answerBackGrounds[A_index].setVisible(true);
          this.answerBackGrounds[this.questionData.correctAnswerIndex].setVisible(true);


          //get the new question 
          //this.time.delayedCall(500, this.showQuestionImage, [this.actualQuestion], this);
          this.time.delayedCall(500, () => {this.displayQuestion(this.actualQuestion);}, [], this);
        }
      }
    end(){
        this.musicSound.stop();
        this.scene.start('end');
    }
}
